@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								{{ __('reports.attendance_title') }}
							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-between">
									<div class="report-btns">
										<a href="{{ route('reports.attendance', ['type' => 'csv'] ) }}"
											class="btn btn-default">
											<i class="fas fa-file-csv"></i>
											{{ __('reports.export') }}
										</a>
										<a href="{{ route('reports.attendance', ['type' => 'print'] ) }}" rel="noopener"
											target="_blank" class="btn btn-default">
											<i class="fas fa-print"></i>
											{{ __('reports.print') }}
										</a>
									</div>
									<form class="w-50" method="post" action="{{ route('reports.attendance') }}">
										{{ csrf_field() }}
										<div class="row no-gutters">
											<div class="col-md-6 pr-2">
												<select class="form-control" name="search" required>
													<option value="all" {{ $keyword=="all" ? "selected" : "" }}>All
													</option>
													<option value="today" {{ $keyword=="today" ? "selected" : "" }}>
														Today</option>
													<option value="this_week" {{ $keyword=="this_week" ? "selected" : ""
														}}>
														This Week
													</option>
													<option value="this_month" {{ $keyword=="this_month" ? "selected"
														: "" }}>
														This Month
													</option>
													<option value="last_month" {{ $keyword=="last_month" ? "selected"
														: "" }}>
														Last Month
													</option>
													<option value="last_three_months" {{ $keyword=="last_three_months"
														? "selected" : "" }}>
														Last 3 Months
													</option>
													<option value="last_six_months" {{ $keyword=="last_six_months"
														? "selected" : "" }}>
														Last 6 Months
													</option>
													<option value="this_year" {{ $keyword=="this_year" ? "selected" : ""
														}}>
														This Year
													</option>
													<option value="last_year" {{ $keyword=="last_year" ? "selected" : ""
														}}>
														Last Year
													</option>
												</select>
											</div>
											<div class="col-md-6">
												<div class="input-group mb-3">
													<select class="form-control select-member" name="member">
														<option value="all" {{ $member=="all" ? "selected" : "" }}>
															All Member
														</option>
														@foreach($members as $singleMember)
														<option value="{{ $singleMember->id }}" {{
															$member==$singleMember->id ? "selected" : "" }}>
															{{ $singleMember->name }}
														</option>
														@endforeach
													</select>
													<div class="input-group-append">
														<button class="btn btn-primary" type="submit">
															<i class="fas fa-search"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th class="nowrap fixed-width-td">{{ __('reports.th_photo') }}</th>
													<th class="nowrap">{{ __('reports.th_name') }}</th>
													<th class="nowrap">{{ __('reports.th_reg_no') }}</th>
													<th class="nowrap">{{ __('reports.th_membership_type') }}</th>
													<th>{{ __('reports.th_date') }}</th>
													<th>{{ __('reports.th_day') }}</th>
													<th>{{ __('reports.th_status') }}</th>
													<th class="nowrap fixed-width-td">{{ __('reports.th_taken_by') }}
													</th>
												</tr>
											</thead>
											<tbody>
												@foreach($attendances as $attendance)
												<tr>
													<td class="align-middle">
														<div class="img-circle elevation-2 profile-image"
															style="background-image: url('{{ img_url($attendance->member->profile_picture) }}');">
														</div>
													</td>
													<td class="align-middle nowrap">
														{{ $attendance->member->name }}
													</td>
													<td class="align-middle nowrap">
														{{ $attendance->member->reg_no }}
													</td>
													<td class="align-middle nowrap">
														{{ $attendance->member->latest_membership->membership_type->name
														}}
													</td>
													<td class="align-middle nowrap">
														{{ format_date($attendance->attendance_date) }}
													</td>
													<td class="align-middle">
														{{ day_name($attendance->attendance_date) }}
													</td>
													<td class="align-middle nowrap">
														{!! attendance_status_badge($attendance->status) !!}
													</td>
													<td class="align-middle nowrap">
														{{ $attendance->user->name }}
													</td>
												</tr>
												@endforeach
												@if(count($attendances) == 0)
												<tr>
													<td colspan="11">
														<p class="text-center mb-0">{{ __('reports.no_record_found') }}
														</p>
													</td>
												</tr>
												@endif
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										@if($paginate)
										{{ $attendances->links() }}
										@endif
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection
@section('js-script')
<!-- PAGE SPECIFIC CUSTOM SCRIPT -->
<script>
	$(function () {
		"use strict";
		// INITIALIZE SELECT2 ELEMENT
		$('.select-member').select2({
			theme: 'bootstrap4'
		});
	});
</script>
@endsection